/*
 *  kexbases\netapi32\_netapi32_stubs.c
 *
 *  Copyright (C) 2009, Xeno86
 *  Copyright (C) 2016, jumper
 *
 *  This file is part of KernelEx source code.
 *
 *  KernelEx is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published
 *  by the Free Software Foundation; version 2 of the License.
 *
 *  KernelEx is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with GNU Make; see the file COPYING.  If not, write to
 *  the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include "common.h"

#define ERROR_NS              50L
#define ERROR_NI             120L
#define HRESULT_NI    0x80004001L
#define STATUS_NI     0xC0000002L


/*
NetAccessAdd=>Svrapi:
NetAccessCheck=>Svrapi:
NetAccessDel=>Svrapi:
NetAccessEnum=>Svrapi:
NetAccessGetInfo=>Svrapi:
NetAccessGetUserPerms=>Svrapi:
NetAccessSetInfo=>Svrapi:
RxNetAccessAdd=>Svrapi:
RxNetAccessDel=>Svrapi:
RxNetAccessEnum=>Svrapi:
RxNetAccessGetInfo=>Svrapi:
RxNetAccessGetUserPerms=>Svrapi:
RxNetAccessSetInfo=>Svrapi:
RxNetServerEnum@40
RxNetUserPasswordSet@16
RxRemoteApi
*/

 rs_UNIMPL_FUNC(DsEnumerateDomainTrustsW, STATUS_NI, 4);
 rs_UNIMPL_FUNC(DsGetDcNameA, STATUS_NI, 6);  //ListUsbDrives 1.7.8.0 5/19/08
 rs_UNIMPL_FUNC(DsGetDcNameW, STATUS_NI, 6);  //cryptui 5.131.2195.6825 (bwc v24d) 
 rs_UNIMPL_FUNC(DsGetDcNameWithAccountW, STATUS_NI, 8);
 rs_UNIMPL_FUNC(I_NetNameCanonicalize, STATUS_NI, 6);
 rs_UNIMPL_FUNC(I_NetNameValidate, STATUS_NI, 4);
 rs_UNIMPL_FUNC(NetAlertRaise, ERROR_NS, 3);
 rs_UNIMPL_FUNC(NetAlertRaiseEx, ERROR_NS, 4);
 //rs_UNIMPL*FUNC(NetApiBufferAllocate, STATUS_NI, 2);
 //rs_UNIMPL*FUNC(NetApiBufferFree, STATUS_NI, 1);
 rs_UNIMPL_FUNC(NetFileGetInfo, STATUS_NI, 4);
 rs_UNIMPL_FUNC(NetGetAnyDCName, STATUS_NI, 3);
 rs_UNIMPL_FUNC(NetGetDCName, STATUS_NI, 3);
 rs_UNIMPL_FUNC(NetGetJoinInformation, STATUS_NI, 3);  //ie8:urlmon delay-load
 rs_UNIMPL_FUNC(NetGroupEnum, STATUS_NI, 7);
 rs_UNIMPL_FUNC(NetGroupGetInfo, STATUS_NI, 4);
 rs_UNIMPL_FUNC(NetGroupGetUsers, STATUS_NI, 8);
 rs_UNIMPL_FUNC(NetLocalGroupAddMembers, STATUS_NI, 5);
 rs_UNIMPL_FUNC(NetLocalGroupGetMembers, STATUS_NI, 8);
 rs_UNIMPL_FUNC(NetMessageBufferSend, STATUS_NI, 5);
 rs_UNIMPL_FUNC(NetMessageNameAdd, STATUS_NI, 2);
 rs_UNIMPL_FUNC(NetMessageNameDel, STATUS_NI, 2);
 rs_UNIMPL_FUNC(NetMessageNameEnum, STATUS_NI, 7);
 rs_UNIMPL_FUNC(NetRemoteTOD, STATUS_NI, 2);
 rs_UNIMPL_FUNC(NetServerEnum, STATUS_NI, 9);

 rs_UNIMPL_FUNC(NetServerGetInfo, STATUS_NI, 3);
 rs_UNIMPL_FUNC(NetSessionDel, STATUS_NI, 3);
 rs_UNIMPL_FUNC(NetSessionEnum, STATUS_NI, 9);
 rs_UNIMPL_FUNC(NetSessionGetInfo, STATUS_NI, 5);
 rs_UNIMPL_FUNC(NetShareAdd, STATUS_NI, 4);
 rs_UNIMPL_FUNC(NetShareDel, STATUS_NI, 3);
 rs_UNIMPL_FUNC(NetShareEnum, STATUS_NI, 7);
 rs_UNIMPL_FUNC(NetShareGetInfo, STATUS_NI, 4);
 rs_UNIMPL_FUNC(NetShareSetInfo, STATUS_NI, 5);
/*
NetServerGetInfo=>Svrapi:  ;=o3
NetSessionDel=>Svrapi:  ;=o3
NetSessionEnum=>Svrapi:  ;=o9
NetSessionGetInfo=>Svrapi:  ;=o5
NetShareAdd=>Svrapi:  ;=o4
NetShareDel=>Svrapi:  ;=o3
NetShareEnum=>SvrApi:  ;=o7
NetShareGetInfo=>SvrApi:  ;=o4
NetShareSetInfo=>SvrApi:  ;=o5
*/

 rs_UNIMPL_FUNC(NetUseAdd, STATUS_NI, 4);
 rs_UNIMPL_FUNC(NetUseDel, STATUS_NI, 3);
 rs_UNIMPL_FUNC(NetUseEnum, STATUS_NI, 7);
 rs_UNIMPL_FUNC(NetUseGetInfo, STATUS_NI, 4);
 rs_UNIMPL_FUNC(NetUserDel, STATUS_NI, 2);
 rs_UNIMPL_FUNC(NetUserEnum, STATUS_NI, 8);
 rs_UNIMPL_FUNC(NetUserGetGroups, STATUS_NI, 7);
 rs_UNIMPL_FUNC(NetUserGetInfo, STATUS_NI, 4);
 rs_UNIMPL_FUNC(NetUserGetLocalGroups, STATUS_NI, 8);
 rs_UNIMPL_FUNC(NetWkstaGetInfo, STATUS_NI, 3);
 rs_UNIMPL_FUNC(NetWkstaTransportEnum, STATUS_NI, 7); //GameRanger
